/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef COMMENTFORM_H
#define COMMENTFORM_H

#include "uic_commentform.h"
#include "../../dataaccess/dbconnection.h"
#include "../../dataaccess/dbmastermanager.h"

/**
 * This form allows the user to change the comment of a database object.
 */
class CommentForm: public UicCommentForm
{
	Q_OBJECT

public:
  /**
   * Lists the different types of comments that this form can manipulate.
   */	
	enum CommentType { TableComment, DatabaseComment, ViewComment, IndexComment,
										 FunctionComment, TriggerComment, SequenceComment };
										 			
protected:	
	DBConnection m_oDBConn;
	DBMasterManager m_oDBMasterMgr;
	CommentType m_enumCommentType;		// the type of object that we are commenting	
	string m_strObjectName;			// the name of the object that is to be commented
				
public:
	
	/**
 	 * Constructor
   */		
  CommentForm(QWidget* pqoParent, const DBConnection & roDBConn, CommentType enumCommentType);

  /**
   * This method is used to set the comment to be displayed.
   */
  void setComment(const QString & rqstrComment);

  /**
   * This method is used to set the object name.
   */
  void setObjectName(const string & rstrObjectName);

public slots:
	/**
	 * This method is used to save the comment to the database.
	 */
	void saveComment();
	
	 	
};


#endif


